/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawning;

import com.lycanitesmobs.core.spawning.CustomSpawner;
import com.lycanitesmobs.core.spawning.SpawnTypeBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnTypeLunar
extends SpawnTypeBase {
    public SpawnTypeLunar(String typeName) {
        super(typeName);
        CustomSpawner.instance.updateSpawnTypes.add(this);
    }

    @Override
    public boolean canSpawn(long tick, World world, BlockPos originPos, int rank) {
        if (!super.canSpawn(tick, world, originPos, rank)) {
            return false;
        }
        if (world.field_73011_w.getDimension() == 1 && world.field_73012_v.nextDouble() >= this.chance) {
            return true;
        }
        return world.field_73011_w.func_76559_b(world.func_72820_D()) == 0 && !world.field_73011_w.isDaytime();
    }

    @Override
    public List<BlockPos> getSpawnCoordinates(World world, BlockPos originPos) {
        ArrayList<BlockPos> blockCoords = null;
        int range = this.getRange(world);
        for (int i = 0; i < this.blockLimit; ++i) {
            BlockPos chunkCoords = this.getRandomSkyCoord(world, originPos, range);
            if (chunkCoords == null) continue;
            if (blockCoords == null) {
                blockCoords = new ArrayList<BlockPos>();
            }
            blockCoords.add(chunkCoords);
        }
        return blockCoords;
    }
}

